#---------------------------------------------------------------------------
# Copyright 2012 The Open Source Electronic Health Record Agent
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#---------------------------------------------------------------------------

import time
from OSEHRAHelper import PROMPT

#---------------------------------------------------------------------
# Create and Christen the New Domain
#---------------------------------------------------------------------

def SetupDomain(VistA):
  VistA.wait(PROMPT)
  VistA.write('S DUZ=1 D Q^DI')
  VistA.wait('Select OPTION:')
  VistA.write('1')
  VistA.wait('INPUT TO WHAT FILE')
  VistA.write('DOMAIN\r')
  VistA.wait('Select DOMAIN NAME')
  VistA.write('DEMO.OSEHRA.ORG\rY\r^\r\r')
  VistA.wait(PROMPT)
  VistA.write('D CHRISTEN^XMUDCHR')
  VistA.wait('Are you sure you want to change the name of this facility?')
  VistA.write('Yes')
  VistA.wait('Select DOMAIN NAME')
  VistA.write('DEMO.OSEHRA.ORG')
  VistA.wait('PARENT')
  VistA.write('')
  VistA.wait('TIME ZONE')
  VistA.write(time.strftime('%Z').replace(' Time',''))
  index = VistA.multiwait([VistA.prompt,'TIME ZONE'])
  if index==1:
    VistA.write('EST')
    VistA.wait(PROMPT)
  VistA.IEN('DOMAIN','DEMO.OSEHRA.ORG')
  VistA.wait(PROMPT)
  VistA.write('S $P(^XWB(8994.1,1,0),"^")=' + VistA.IENumber)
  VistA.write('S $P(^XTV(8989.3,1,0),"^")=' + VistA.IENumber)
  VistA.getenv('ROU')
  VistA.wait(PROMPT)
  VistA.write('S DUZ=1 D Q^DI')
  VistA.wait('Select OPTION')
  VistA.write('UTILITY')
  VistA.wait('UTILITY OPTION')
  VistA.write('RE')
  VistA.wait('MODIFY WHAT FILE')
  VistA.write('8989.3\rNO\rY\rY')
  VistA.wait('UTILITY OPTION', 600)
  VistA.write('RE')
  VistA.wait('MODIFY WHAT FILE')
  VistA.write('8994.1\rNO\rY\rY\r')
  VistA.wait('Select OPTION')
  VistA.write('')

